//package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

/**
 * Complete code for Example 7-13, Ranking Products by Units Sold, in 
 * Chapter 7, Making Queries Using Source Methods, in the 
 * Oracle OLAP Developer's Guide to the  OLAP API.
 * 
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 * 
 * @author Oracle Corporation
 */
public class RankingProductsByUnitsSold 
{
  public RankingProductsByUnitsSold()
  {
  }

  public void run(String[] args)
  {
    Context10g context = new Context10g(args, false);
    DataProvider dp = context.getDataProvider();

    context.println("Example 7-13, Ranking Products by Units Sold");

    // Get the primary dimensions and the measure.
    MdmPrimaryDimension[] mdmPrimDims = 
         context.getMdmPrimaryDimensionsByName(new String[]
                                               {"PRODUCT", 
                                                "CUSTOMER", 
                                                "CHANNEL", 
                                                "TIME"});

    MdmMeasure mdmUnits = context.getMdmMeasureByName("UNITS");

    MdmPrimaryDimension mdmProdDim = (MdmPrimaryDimension) mdmPrimDims[0];
    Source prodDim = mdmProdDim.getSource();
    
    MdmLevelHierarchy mdmProdRollup = (MdmLevelHierarchy)
                                       mdmProdDim.getDefaultHierarchy();
    // Get the Source for the default product hierarchy                                   .
    StringSource prodRollup = (StringSource) mdmProdRollup.getSource();

   // Get the Source objects for the measure and for the default hierarchies 
   // of the other dimensions.
    NumberSource units = (NumberSource) mdmUnits.getSource();
    StringSource custHier = 
               (StringSource) mdmPrimDims[1].getDefaultHierarchy().getSource();
    StringSource chanHier = 
               (StringSource) mdmPrimDims[2].getDefaultHierarchy().getSource();
    StringSource timeHier = 
               (StringSource) mdmPrimDims[3].getDefaultHierarchy().getSource();

    // Select the Direct Sales channel, the year 2001, and all customers.
    Source chanSel = chanHier.selectValue("CHANNEL_ROLLUP::CHANNEL::2"); 
    Source timeSel = timeHier.selectValue("CALENDAR::YEAR::4");
    Source custSel = custHier.selectValue("SHIPMENTS_ROLLUP::ALL_CUSTOMERS::1");

    // Get the short value description attribute and the Source for it.
    Source prodShortDescr = mdmProdDim.getShortValueDescriptionAttribute()
                                      .getSource();

    // Get the parent attribute of the PRODUCT dimension and the Source for it.
    MdmAttribute mdmProdParentAttr = mdmProdRollup.getParentAttribute();
    Source prodParent = mdmProdParentAttr.getSource();

    // Reverse the parent relation to get a children relation.
    Source prodRollupChildren = prodRollup.join(prodParent, 
                                                prodRollup.value());
    // Select the PC family parents.
    Source pcParents = prodRollup.selectValues(new String[] 
                                                {"PRODUCT_ROLLUP::FAMILY::4",
                                                 "PRODUCT_ROLLUP::FAMILY::5"});
    // Select the children of the PC parents.
    Source pcChildren = prodRollupChildren.join(pcParents);
    // Append the children to the parents.
    
    Source pcParentsAndChildren = pcParents.appendValues(pcChildren);

    // First result:  PC products unit sales ranked relative to all products.
    Source result1 = units.join(prodRollup,
                                dp.getEmptySource(),
                                Source.COMPARISON_RULE_REMOVE,
                                false)
                           .select(units.value().gt(units)).count().plus(1)
                           .join(pcParentsAndChildren)
                           .joinHidden(custSel)
                           .joinHidden(timeSel)
                           .joinHidden(chanSel)
                           .sortAscending();
                           
    // Second result:  PC products unit sales ranked relative to each other.
    Source result2 = //units.join(sortedPcParentsAndChildren,
                     units.join(pcParentsAndChildren,
                                dp.getEmptySource(),
                                Source.COMPARISON_RULE_REMOVE,
                                false)
                          .select(units.value().gt(units)).count().plus(1)
                          .join(prodRollup)
                          .joinHidden(custSel)
                          .joinHidden(timeSel)
                          .joinHidden(chanSel)
                          .sortAscending();

                          
    
    context.commit();

    context.println("result1");
    context.displayResult(result1);

    context.println("result2");
    context.displayResult(result2);
  } 

  public static void main(String[] args)
  {
    new RankingProductsByUnitsSold().run(args);
  }
}


